#version 330
#extension GL_EXT_gpu_shader4 : enable
// Apollonian DreamsMod01.fsh  by   krakel

//https://www.shadertoy.com/view/WdfXR4
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
uniform int  iFrame;
#define iTime u_Elapsed*0.0885 //14159  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by krakel, 2019
// License: Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License

#define sqrt3 sqrt(3.)
#define pixelRadius .5/iResolution.x
//#define Time .1*float(iFrame)/30.
#define Time iTime

//this AA is expensive and rather ineffective
#define AA 0

vec3 sunDir = normalize(vec3(0, 0, 1));
float viewDist = 30.;
vec3 sunLight = vec3(2.,2.,1.6);
vec3 ambLight = vec3(.5, .8, .9);
vec3 fogColor = vec3(.8,.8,.9);

vec3 triangles(vec3 p){
    float zm = 1.;
    p.x = p.x-sqrt3*(p.y+.5)/3.;
	p = vec3(mod(p.x+sqrt3/2.,sqrt3)-sqrt3/2., mod(p.y+.5,1.5)-.5 , mod(p.z+.5*zm,zm)-.5*zm);
	p = vec3(p.x/sqrt3, (p.y+.5)*2./3. -.5 , p.z);
	p = p.y>-p.x ? vec3(-p.y,-p.x , p.z) : p;
	p = vec3(p.x*sqrt3, (p.y+.5)*3./2.-.5 , p.z);
	return vec3(p.x+sqrt3*(p.y+.5)/3., p.y , p.z);
}
float sdf(vec3 p){
    float scale = 1.;
	float s = 1./3.;
	for( int i=0; i<10;i++ )
	{
		p = triangles(p);
		float r2= dot(p,p);
		float k = s/r2;
		p = p * k;
		scale=scale*k;
    }
	return .3*length(p)/scale		-.001/sqrt(scale);
}

float march(vec3 ro, vec3 rd){
    float t = 0.03;
    float h = 5.;
    for( int i=0; i<80; i++ )
    {
        if(h<t*pixelRadius || t>viewDist){break;}
	    h = sdf( ro+rd*t );
        t += h;
    }
    if(h>t*pixelRadius){t=viewDist*2.;}
    return t;
}

vec3 getNormal( in vec3 p, in float t )
{
    float precis = 0.0001 * t;

    vec2 e = vec2(1.0,-1.0)*precis;
    return normalize( e.xyy*sdf( p + e.xyy ) + 
					  e.yyx*sdf( p + e.yyx ) + 
					  e.yxy*sdf( p + e.yxy ) + 
                      e.xxx*sdf( p + e.xxx ) );
}
float ao(vec3 p,vec3 n){
	float r=0.;
    float t=0.;
	for( int i=0; i<3;i++ )
	{
		t=t+.01;
		r=r + sdf(p+n*t)/t;
    }
    return smoothstep(.0,1.7,r);
}

float shadowRay(vec3 p,vec3 n,vec3 ld){
    p = p + n*.1;
    float t = .1;
    float h = 5.;
    for( int i=0; i<50; i++ )
    {
        if(h<t*pixelRadius || t>2.){break;}
	    h = sdf( p+ld*t );
        t += h;
    }
    return smoothstep(0.,1.,t/2.);
}

vec3 fog(float t, vec3 col, float density){
   return  mix(col , fogColor, 1.-exp(-t*density));
}

float pulse(float t){
    return pow(t,3.);
}

vec3 render(vec3 ro, vec3 rd){
    float t= march(ro,rd);
    vec3 col = vec3(0);
    if(t<viewDist){
        vec3 p = ro+t*rd;
    	vec3 n = getNormal(p, t);
        col = sunLight*vec3 ( dot(n, sunDir ) );
        col *= shadowRay(p,n,sunDir);
        float ao = ao(p,n);
        col += ambLight*mix(ao,.2+.8/ao, pulse(.5+sin(p.z+10.*Time)*.5));
        col *= .6;
        col = fog(t, col, .3);
    }else{
        col = fogColor;
    }
    return col;
}

vec3 jitter( int i){
    return pixelRadius* fract(123.*sin(vec3(15,17,19)*float(i)));
}

vec3 AArender(vec3 ro, vec3 rd){
    if(AA>1){
    vec3 col = vec3(0);
    for( int i=0; i<AA; i++){
        col += render(ro, normalize(rd+jitter(i)));
    }
        return col/float(AA);}
    else{return render(ro,rd);}
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.x - .5*iResolution.xy/iResolution.x;
    
    vec3 camPos = vec3(0,1,.5) + Time*vec3(1) + .5*vec3(sin(Time), cos(Time) ,0 );
    vec3 camDir = normalize(vec3(1,0,1) + vec3(0, cos(Time),sin(Time)) );
    vec3 camRi  = normalize(cross(camDir, vec3(0,sin(Time),cos(Time))));
    vec3 camUp  = normalize(cross(camDir, camRi));
    
    sunDir = normalize(vec3(0, sin(Time),cos(Time)));
    sunLight = vec3(sin(Time),cos(Time),0);
    
    gl_FragColor = vec4(AArender(camPos, normalize(camDir + camRi*uv.x + camUp*uv.y) ), 1.0);
}